#! /usr/bin/env python

#*******************************************************************************
# import standard Python modules
#******************************************************************************/
import string
import sys
import os

#*******************************************************************************
# import TAU Python-Classes
#******************************************************************************/
import PyPrep
import PySolv
import PyPara

#*******************************************************************************
# add to path so that python finds the PyDeform.py class (not standard TAU)
#******************************************************************************/
cwd = os.getcwd()
sys.path += [cwd]
import PyDeform

#*******************************************************************************
# sample script for running  Tau  with deformation "Type of grid movement: 5"
#******************************************************************************/
primgrid_file_io        = 1
surface_file_io         = 1

steady_initial_solution = 1
ntimesteps              = 5 # 0 if only steady solution to be done
shape_file_prefix       = "Shape/delta_surf"
has_looped              = 0

#*******************************************************************************
# define unsteady parameter settings
#******************************************************************************/
def set_para_unsteady():

    para_list = {}
    para_list['Unsteady calculation (0/1/2)']            = 1
    para_list['Unsteady physical time step size']        = 0.01
    para_list['Type of grid movement']                   = 5
    para_list['Unsteady physical time steps']            = 1
    para_list['Unsteady inner iterations per time step'] = 10
    para_list['Unsteady show pseudo time steps (0/1)']   = 1
    return para_list

#*******************************************************************************
# define initial steady parameter settings for start from scratch
#******************************************************************************/
def set_para_steady():

    para_list = {}
    para_list['Maximal time step number']     = 10
    para_list['Unsteady calculation (0/1/2)'] = 0
    para_list['Type of grid movement']        = 0
    para_list['Restart-data prefix']          = "(none)"
    para_list['Initialise deformation']       = 1
    return para_list

#*******************************************************************************
# define new deformed coord file parameter
#******************************************************************************/
def set_para_surf(surf):

    para_list = {}
    para_list['Deformed coordinates filename']     = surf
    return para_list

#*******************************************************************************
#
#******************************************************************************/
def print_this_module(str):
    print 80 * "#"
    print str
    print 80 * "#"

#-------------------------------------------------------------------------------
# create instances of the TauPython classes
#-------------------------------------------------------------------------------
Prep   = PyPrep.Preprocessing(para_path)
Solver = PySolv.Solver(para_path)
Para   = PyPara.Parafile(para_path)

#-------------------------------------------------------------------------------
# Setup Deformation script
#-------------------------------------------------------------------------------
Deform = PyDeform.DeformAmif(shape_file_prefix)

#-------------------------------------------------------------------------------
# perform initial steady state solution
#-------------------------------------------------------------------------------
if steady_initial_solution:
     Para.update(set_para_steady())

     Prep.run(write_dualgrid=0)

     Solver.init()
     Solver.outer_loop()
     Solver.output()
     Solver.stop()
     tau_free_dualgrid()

     Para.update(set_para_unsteady())

     cmd = "tau2plt %s" % (para_path)
     os.system(cmd)
     has_looped = 1

#-------------------------------------------------------------------------------
# time loop with deforming grid
#-------------------------------------------------------------------------------
for i in range(ntimesteps):
  step = i+1

  #--------------------------------------------------------------------------
  # flight-shape
  #--------------------------------------------------------------------------
  print_this_module("Start surface deformation for step "+str(step))
  surf = Deform.create_deformed_surface(para_path, step)
  Para.update(set_para_surf(surf))

  #--------------------------------------------------------------------------
  # deformation
  #--------------------------------------------------------------------------
  print_this_module("Start deformation for deformation step "+str(step))

  tau_deform_read_primgrid(para_path)
  tau_close_surface_buffer()           # force deformation to read from file!
  tau_deform(para_path)

  if i == ntimesteps - 1:
    tau_deform_write_primgrid(para_path)
  elif primgrid_file_io:
    tau_deform_write_primgrid(para_path)
    tau_free_primgrid()

  #--------------------------------------------------------------------------
  # preprocessor
  #--------------------------------------------------------------------------
  print_this_module("Start preprocessing for deformation step "+str(step))

  Prep.init(free_primgrid=0)
  Prep.compute()
  #Prep.output() # write dualgrid to disk
  Prep.finalize()
  if primgrid_file_io:
    tau_free_primgrid()

  #--------------------------------------------------------------------------
  # solver
  #--------------------------------------------------------------------------
  print_this_module("Start solver for deformation step "+str(step))

  if has_looped == 1:
    tau_solver_scale_dualgrids()

  Solver.init()
  Solver.outer_loop()
  
  if i == ntimesteps - 1:
     tau_solver_print_integrals()
     tau_solver_output_field()

  if surface_file_io:
    tau_solver_output_field()
    tau_solver_output_surface()
  else:
    tau_solver_buffer_surface()

  Solver.stop()
  tau_free_dualgrid()

  cmd = "tau2plt %s" % (para_path)
  os.system(cmd)

  has_looped = 1

tau_free_primgrid()
tau_free_prims()
Solver.finalize()
tau("exit")
